/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.xel.taglib;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.idom.Element;
import org.zkoss.idom.input.SAXBuilder;
import org.zkoss.idom.util.IDOMs;
import org.zkoss.lang.Classes;
import org.zkoss.util.IllegalSyntaxException;
import org.zkoss.util.resource.AbstractLoader;
import org.zkoss.util.resource.ClassLocator;
import org.zkoss.util.resource.Locator;
import org.zkoss.util.resource.ResourceCache;
import org.zkoss.util.resource.XMLResourcesLocator;
import org.zkoss.xel.Function;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.xel.XelException;
import org.zkoss.xel.taglib.FunctionDefinition;
import org.zkoss.xel.taglib.Taglib;
import org.zkoss.xel.taglib.TaglibDefinition;
import org.zkoss.xel.util.MethodFunction;
import org.zkoss.xel.util.TaglibMapper;

public class Taglibs {
    private static final Logger log = LoggerFactory.getLogger(Taglibs.class);
    private static final ResourceCache<URL, TaglibDefinition> _reces;
    private static final AtomicReference<Map<String, URL>> _defURLsRef;

    public static final FunctionMapper getFunctionMapper(List<Taglib> taglibs, Map<String, Class<?>> imports, Locator loc) {
        return Taglibs.getFunctionMapper(taglibs, imports, null, loc);
    }

    public static final FunctionMapper getFunctionMapper(Collection<Taglib> taglibs, Map<String, Class<?>> imports, Locator loc) {
        return Taglibs.getFunctionMapper(taglibs, imports, null, loc);
    }

    public static final FunctionMapper getFunctionMapper(List<Taglib> taglibs, Map<String, Class<?>> imports, List<FunctionDefinition> funcs, Locator loc) {
        return Taglibs.getFunctionMapper(taglibs, imports, funcs, loc);
    }

    public static final FunctionMapper getFunctionMapper(Collection<Taglib> taglibs, Map<String, Class<?>> imports, Collection<FunctionDefinition> funcs, Locator loc) {
        TaglibMapper mapper = null;
        if (taglibs != null && !taglibs.isEmpty()) {
            mapper = new TaglibMapper();
            for (Taglib taglib : taglibs) {
                mapper.load(taglib, loc);
            }
        }
        if (imports != null && !imports.isEmpty()) {
            if (mapper == null) {
                mapper = new TaglibMapper();
            }
            for (Map.Entry<String, Class<?>> me : imports.entrySet()) {
                mapper.addClass(me.getKey(), me.getValue());
            }
        }
        if (funcs != null && !funcs.isEmpty()) {
            if (mapper == null) {
                mapper = new TaglibMapper();
            }
            for (FunctionDefinition fi : funcs) {
                mapper.addFunction(fi.prefix, fi.name, fi.function);
            }
        }
        return mapper;
    }

    public static final FunctionMapper getFunctionMapper(List<Taglib> taglibs, Locator loc) {
        return Taglibs.getFunctionMapper(taglibs, null, loc);
    }

    public static final FunctionMapper getFunctionMapper(Collection<Taglib> taglibs, Locator loc) {
        return Taglibs.getFunctionMapper(taglibs, null, loc);
    }

    public static final Map<String, Function> loadFunctions(URL xmlURL) throws Exception {
        return Taglibs.load((URL)xmlURL).functions;
    }

    public static final Map<String, Function> loadFunctions(Element root) throws Exception {
        return Taglibs.load((Element)root).functions;
    }

    public static final TaglibDefinition load(URL xmlURL) throws Exception {
        return _reces.get(xmlURL);
    }

    public static final TaglibDefinition load(Element root) throws Exception {
        String clsnm;
        String name;
        TaglibDefinition tagdef = new TaglibDefinition();
        Exception excp = null;
        for (Element e : root.getElements("function")) {
            Class<?> cls;
            name = IDOMs.getRequiredElementValue(e, "name");
            clsnm = IDOMs.getRequiredElementValue(e, "function-class");
            String sig = IDOMs.getRequiredElementValue(e, "function-signature");
            try {
                cls = Classes.forNameByThread(clsnm);
            }
            catch (ClassNotFoundException ex) {
                log.error("Class not found: " + clsnm + ", " + e.getLocator(), (Throwable)ex);
                excp = ex;
                continue;
            }
            try {
                Method mtd = Classes.getMethodBySignature(cls, sig, null);
                if ((mtd.getModifiers() & 8) != 0) {
                    tagdef.functions.put(name, new MethodFunction(mtd));
                    continue;
                }
                log.error("Not a static method: {}", (Object)mtd);
            }
            catch (ClassNotFoundException ex) {
                log.error("Relavant class not found when loading " + clsnm + ", " + e.getLocator(), (Throwable)ex);
                excp = ex;
            }
            catch (NoSuchMethodException ex) {
                log.error("Method not found in " + clsnm + ": " + sig + " " + e.getLocator(), (Throwable)ex);
                excp = ex;
            }
            catch (IllegalSyntaxException ex) {
                log.error("Illegal Signature: " + sig + " " + e.getLocator(), (Throwable)ex);
                excp = ex;
            }
        }
        for (Element e : root.getElements("import")) {
            name = IDOMs.getRequiredElementValue(e, "import-name");
            clsnm = IDOMs.getRequiredElementValue(e, "import-class");
            try {
                tagdef.classes.put(name, Classes.forNameByThread(clsnm));
            }
            catch (ClassNotFoundException ex) {
                log.error("Class not found: " + clsnm + ", " + e.getLocator(), (Throwable)ex);
                excp = ex;
            }
        }
        if (excp != null) {
            throw excp;
        }
        return tagdef;
    }

    public static final URL getDefaultURL(String uri) {
        return Taglibs.getDefaultTLDs().get(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map<String, URL> getDefaultTLDs() {
        Map<String, URL> defURLs = _defURLsRef.get();
        if (defURLs != null) {
            return defURLs;
        }
        Class<Taglibs> clazz = Taglibs.class;
        synchronized (Taglibs.class) {
            defURLs = _defURLsRef.get();
            if (defURLs != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return defURLs;
            }
            HashMap<String, URL> urls = new HashMap<String, URL>();
            try {
                ClassLocator loc = new ClassLocator();
                for (XMLResourcesLocator.Resource res : loc.getDependentXMLResources("metainfo/tld/config.xml", "config-name", "depends")) {
                    if (log.isDebugEnabled()) {
                        log.debug("Loading {}", (Object)res.url);
                    }
                    try {
                        if (!IDOMs.checkVersion(res.document, res.url)) continue;
                        Taglibs.parseConfig(urls, res.document.getRootElement(), loc);
                    }
                    catch (Exception ex) {
                        log.error("Failed to parse " + res.url, (Throwable)ex);
                    }
                }
            }
            catch (Exception ex) {
                log.error("", (Throwable)ex);
            }
            defURLs = urls.isEmpty() ? Collections.emptyMap() : urls;
            _defURLsRef.set(defURLs);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return defURLs;
        }
    }

    private static void parseConfig(Map<String, URL> urls, Element root, Locator loc) {
        for (Element el : root.getElements("taglib")) {
            String s = IDOMs.getRequiredElementValue(el, "taglib-location");
            URL url = loc.getResource(s.startsWith("/") ? s.substring(1) : s);
            if (url != null) {
                urls.put(IDOMs.getRequiredElementValue(el, "taglib-uri"), url);
                continue;
            }
            log.error("{} not found, {}", (Object)s, (Object)el.getLocator());
        }
    }

    static {
        try {
            _reces = new ResourceCache<URL, TaglibDefinition>(new TaglibLoader());
            _reces.setCheckPeriod(1800000);
        }
        catch (Exception ex) {
            throw XelException.Aide.wrap(ex);
        }
        _defURLsRef = new AtomicReference();
    }

    private static class TaglibLoader
    extends AbstractLoader<URL, TaglibDefinition> {
        private TaglibLoader() {
        }

        @Override
        public TaglibDefinition load(URL src) throws Exception {
            Element root = new SAXBuilder(true, false, true).build(src).getRootElement();
            return Taglibs.load(root);
        }
    }
}

